#!/usr/bin/env python

"""
Append DTB to kernel Image

Usage: ms_bin_option_update_int.py IMAGE_PATH DTB_PATH
"""

import os
import sys
import mmap
import struct

if __name__ == '__main__':

    name = b'#MS_DTB#'

    with open(sys.argv[2], "rb") as dtb_file:
        dtb = dtb_file.read()
        size = len(dtb)

    if size > (64*1024):
        print('DTB size 0x%08X too big to fit in 64K limit!!' % size)
        sys.exit()

    fmap = mmap.mmap(os.open(sys.argv[1], os.O_RDWR), 0)
    try:
        offset = fmap.find(name)
        if offset >= 0:
            print('offset:0x%08X' % offset)
            print('  size:0x%08X' % size)
            fmap.seek(offset + 8, os.SEEK_SET)
            fmap.write(struct.pack('<I', size))
            fmap.seek(offset + 16, os.SEEK_SET)
            fmap.write(dtb)
    finally:
        fmap.close()
